<?php
add_action('wp_enqueue_scripts', 'sambaaiprefix_sambaAiAnalytics_cartInteractionsTracking');

function sambaaiprefix_sambaAiAnalytics_cartInteractionsTracking() {

  $isCheckout = is_checkout() ? 'true' : 'false';


  if(WC()->cart){
      $orderItems = WC()->cart->get_cart();
  }


?>

  <!-- Start Samba.ai cart -->
  <script>
    var isOrderPage = <?php echo esc_js($isCheckout); ?>;
    var _yottlyOnload = _yottlyOnload || [];
    _yottlyOnload.push(function() {

      var products = [];

      <?php foreach ($orderItems as $item) { ?>
        products.push({
          productId: '<?php echo esc_js($item['product_id']) ?>',
          amount: <?php echo esc_js(absint($item['quantity'])) ?>
        });
      <?php } ?>

      diffAnalytics.cartInteraction({
        content: products,
        onOrderPage: window.isOrderPage
      });

    });
  </script>

  <script>
  document.addEventListener('DOMContentLoaded', function() {

      document.querySelector('body').addEventListener('added_to_cart', function() {
          sambaaiprefix_reportCartStatusToSamba();
      });

      document.querySelector('body').addEventListener('removed_from_cart', function() {
          sambaaiprefix_reportCartStatusToSamba();
      });

      document.querySelector('body').addEventListener('updated_cart_totals', function() {
          sambaaiprefix_reportCartStatusToSamba();
      });

      var sambaaiprefix_reportCartStatusToSamba = function() {
          var xhr = new XMLHttpRequest();
          xhr.open('POST', '<?php echo esc_js(admin_url('admin-ajax.php')) ?>');
          xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
          xhr.onload = function() {
              if (xhr.status === 200 && xhr.responseText) {
                  // Fix possibly buggy AXAJ output
                  var response = xhr.responseText.substring(xhr.responseText.length - 1) == "0" ? xhr.responseText.substring(0, xhr.responseText.length - 1) : xhr.responseText;
                  // Parse JSON
                  response = JSON.parse(response);
                  // Report to Samba
                  diffAnalytics.cartInteraction({
                      content: response,
                      onOrderPage: window.isOrderPage
                  });
              }
          };
          xhr.onerror = function() {
              console.log(xhr.responseText);
              console.log(xhr.statusText);
          };
          xhr.send('action=sambaaiprefix_retrieveWCCartContent');
      };

  });

  </script>
  <!-- End Samba.ai cart -->
<?php
}
